#!/bin/sh
# GPa_check.sh
# Time-stamp: <2016-08-06 09:43:19 takeshi>
# Author: Takeshi NISHIMATSU
# Ref_1: R. D. King-Smith and David Vanderbilt: PRB 49, 5828 (1994).
# Ref_2: Takeshi Nishimatsu et al.: PRB 82, 134106 (2010).
##
rm -f GPa_check.dat
for GPa in `seq -8 2 8`; do
    printf "%s" $GPa >> GPa_check.dat
    cat > GPa_check.feram <<-EOF
	GPa = $GPa
	#--- Method, Temperature, and mass ---------------
	method = 'md'
	kelvin = 300
	mass_amu = 38.24
	Q_Nose = 0.1
	
	#--- System geometry -----------------------------
	bulk_or_film = 'bulk'
	L = 16 16 16
	
	#--- Elastic Constants ---------------------------
	B11 = 126.731671475652
	B12 =  41.7582963902598
	B44 =  49.2408864348646
	
	#--- From perovskite-optcell2-p.gp ---------------
	B1xx = -185.347187551195 [eV/Angstrom^2]
	B1yy = -3.28092949275457 [eV/Angstrom^2]
	B4yz = -14.5501738943852 [eV/Angstrom^2]
	P_k1 = -267.98013991724 [eV/Angstrom^6]
	P_k2 = 197.500718362573 [eV/Angstrom^6]
	P_k3 = 830.199979293529 [eV/Angstrom^6]
	P_k4 = 641.968099408642 [eV/Angstrom^8]
	P_alpha = 78.9866142426818 [eV/Angstrom^4]
	P_gamma = -115.484148812672 [eV/Angstrom^4]
	#kappa = -1.51821042113588 [eV/Angstrom^2]
	#(- 8.1460516421 (- (/  -3.812330 2) -1.51821042113588)) =>  8.53400622096412 new P_kappa2
	
	#--- Time step -----------------------------------
	dt = 0.002 [pico second]
	n_thermalize = 1
	n_average    = 1
	n_coord_freq = 3
	coord_directory = 'never'
	distribution_directory = 'never'
	
	#--- From eigenvalues2j --------------------------
	# original  P_kappa2 =    8.1460516421 [eV/Angstrom^2] =    0.0838298622 [Hartree/Bohr^2]
	P_kappa2 = 8.53400622096412
	j =  -2.08403 -1.12904  0.68946 -0.61134  0.00000  0.27690  0.00000    [eV/Angstrom^2]
	a0  =   3.98597    [Angstrom]
	Z_star      =  10.33000
	epsilon_inf =   6.86915
	
	#--- Initial dipole configrations ----------------
	init_dipo_avg = 0.00  0.00  0.00
	init_dipo_dev = 0.00  0.00  0.00   [Angstrom]  # Deviation of initial dipole displacements
EOF
    ./feram GPa_check.feram
    cat GPa_check.avg >> GPa_check.dat
done
cat > GPa_check.gp <<-EOF
	# GPa_check.gp is automatically generated by GPa_check.sh
	# Do NOT edit this file.
	##
	set encoding iso_8859_1
	set terminal postscript eps enhanced color "Times-Roman" 22
	set output "GPa_check.eps"
	set key spacing 1.5
	set xrange [-10:10]
	set format y "%.3f"
	set xlabel 'hydrostatic pressure [GPa]'
	set yrange [-0.033:0.033]
	set ytics    0.01
	set format y "%.2f"
	set ylabel 'strain'
	call 'GPa_check.param.gp'
	plot 'GPa_check.dat' using 1:6 t '{/Symbol h}_1' w p ps 2,\\
	     'GPa_check.dat' using 1:7 t '{/Symbol h}_2' w p ps 2,\\
	     'GPa_check.dat' using 1:8 t '{/Symbol h}_3' w p ps 2 pt 4,\\
	     -x*a0**3/(B11+2*B12)/160.22 \\
	     t '1.6022{\327}10^2 {/Times-Italic a}@^3_0 / ({/Times-Italic B}_{11}+2{/Times-Italic B}_{22})' w l lw 2
	set output
	print -8*a0**3/(B11+2*B12)/160.22
EOF
gnuplot  GPa_check.gp
#epstopdf GPa_check.eps
set `cat GPa_check.avg`
echo $5
echo $6
echo $7
#Local variables:
#  compile-command: "OMP_NUM_THREADS=2 make check TESTS=GPa_check.sh; cat GPa_check.sh.log"
#End:
